<?php include 'assets/inc/header.php'; ?>
<style>
  footer,
  header,
  .menu-secundario {
    display: none;
  }
</style>
<style>
  {
    --red: #ad132a;
  }

  .body * {
    font-family: "Poppins", sans-serif;
    font-weight: 300;
    font-style: normal;
    --title-size: 50px;
    max-width: 1200px;
    margin: 0 auto;
  }

  .body hr {
    border-top: 2px solid #ad132a;
    opacity: 1;
    width: 80%;
    max-width: 830px;
    margin: 100px auto 95px auto;
  }

  #page {
    margin: 8vw auto;
  }

  .modal {
    display: none;
    position: fixed;
    z-index: 99;
    left: 28vw;
    top: 14vw;
    overflow: visible;
    background: none;
    transition: opacity 0.5s ease, transform 0.5s ease;
    transform: scale(0.9);
  }

  .modal.fade {
    opacity: 0;
    transition: opacity 0.15s linear;
    transition: opacity 0.5s ease, transform 0.5s ease;
  }

  .modal.show {
    display: block;
    opacity: 1;
    transform: scale(1);
  }

  .modal-body {
    background-color: #fff;
    border-radius: 30px 130px;
    padding: 40px 0;
    -webkit-box-shadow: 2px 2px 10px 0px rgba(194, 194, 194, 1);
    -moz-box-shadow: 2px 2px 10px 0px rgba(194, 194, 194, 1);
    box-shadow: 2px 2px 10px 0px rgba(194, 194, 194, 1);
  }

  .modal-txt {
    padding: 0 30px 0 12vw;
  }

  .modal-body p {
    white-space: pre-line;
    font-size: 14px;
    font-weight: 400;
  }

  .modal-header {
    display: flex;
    align-content: flex-end;
    background-color: transparent !important;
    background: none;
    border-bottom: none;
    justify-content: flex-end;
    padding: 0 40px;
  }

  .modal-header a {
    color: #000;
    text-decoration: none;
    margin: 0 !important;
  }

  .modal-content {
    border: none !important;
    background-color: transparent !important;
    border-radius: 30px 130px
  }

  .painelistas-modal {
    position: absolute;
    left: -4vw;
    top: -180px;
    width: 15vw;
  }

  #main {
    /* background: url('https://upload.madnezz.com.br/be931142cdbf8fc2923ef3ecfc51fea6') no-repeat right 0; */
    background-size: 32vw;
    top: -55px
  }

  #hero {
    min-height: 60vh;
  }

  #hero h1 {
    font-family: "Poppins", sans-serif;
    font-size: 65px;
    font-weight: 300;
    color: #ad132a;
    line-height: 1;
  }

  #hero h1 sub {
    font-size: .6em;
    vertical-align: middle;
    line-height: 1;
    top: .1em;
  }

  #hero h1>span {
    color: #000;
    font-size: 1em;
  }

  #hero h1 .small-1 {
    color: #ad132a;
    font-size: .65em;
    font-weight: 600;
  }

  #hero h1 .small-2 {
    color: #000;
  }

  #cta .container {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 40px;
    padding: 10vw;
  }

  #cta h2 {
    color: #ad132a;
    font-weight: 700;
    font-size: var(--title-size);
    text-align: center;
    margin: auto;
  }

  #cta a {
    background: #ad132a;
    max-width: 260px;
    color: #fff;
    text-decoration: none;
    padding: 12px 24px;
    border-radius: 30px;
  }

  #painelistas h2 {
    font-size: var(--title-size);
    color: #000;
    text-align: center;
    font-weight: 300;
  }

  #painelistas h2 b {
    color: #ad132a;
    font-weight: 600;
  }

  #painelistas .container-painelistas {
    display: flex;
    flex-wrap: wrap;
    gap: 50px 6%;
  }

  #painelistas .container-painelistas .item {
    width: 19%;
    cursor: pointer;
  }

  #painelistas .container-painelistas .item img {
    height: 280px;
    object-fit: contain
  }

  #painelistas .item h3 {
    color: #ad132a;
    font-size: 18px;
    font-weight: 600;
    margin: 20px 0 12px 0;
  }

  #painelistas .item h4 {
    font-size: 14px;
    font-weight: 700;
    margin: 0;
  }

  #painelistas small {
    font-size: 12px;
    line-height: 1.5;
    display: inline-block;
    margin-top: 7px;
  }

  #programacao::before {
    content: '';
    /* background: url('https://www.partagebetim.com.br/wp-content/uploads/sites/3/2024/05/petala_3-1.png') no-repeat right;  */
    width: 23%;
    height: 40vw;
    position: absolute;
    top: 0px;
    right: 0;
    background-size: contain;
  }

  #programacao h2 {
    font-size: var(--title-size);
    font-weight: 600;
    text-align: center;
    color: #ad132a;
  }

  #programacao table {
    font-size: 22px;
  }

  #programacao tr>td {
    color: #ad132a;
    padding-bottom: 30px;
  }

  #programacao tr>td:first-child {
    font-weight: 600;
    min-width: 130px;
    color: #000;
  }

  #programacao td span {
    font-size: .7em;
  }

  #bg-flower {
    position: relative
  }

  #bg-flower img {
    position: absolute;
    width: 21vw;
    top: -14vw
  }

  #fotos {
    /* background: url('https://www.partagebetim.com.br/wp-content/uploads/sites/3/2024/05/petalas_betim.png') no-repeat left; */
    min-height: 29vw;
    background-size: 17vw;
  }

  #fotos .container {
    border-top: 2px solid #ad132a;
    border-bottom: 2px solid #ad132a;
    max-width: 50%;
    padding: 6vw 0;
  }

  #fotos h2 {
    text-align: center;
    font-size: calc(var(--title-size) + 18px);
    font-weight: 600;
  }

  #fotos h2::before {
    content: '';
    position: absolute;
    top: -45px;
    left: calc(50% - 388px);
    color: #ad132a;
    font-size: 41px;
    font-weight: 600;
    line-height: 1;
  }

  #participacao {
    text-align: right;
    /* background: url('https://www.partagebetim.com.br/wp-content/uploads/sites/3/2024/05/petala_betim_2.png') no-repeat left 0; */
    padding: 40px 0;
    background-size: 28vw;
  }

  #participacao .container {
    max-width: 999px;
  }

  #participacao h2 {
    font-size: calc(var(--title-size) + 18px);
    color: #000;
    font-weight: 300;
    margin-bottom: 45px;
    line-height: 1;
  }

  #participacao h2 b {
    color: #ad132a;
    font-weight: 600;
    display: block;
  }

  #participacao p {
    font-size: 28px;
  }

  #participacao p b {
    color: #ad132a;
  }

  #participacao .wpcf7,
  #participacao form {
    display: flex;
    flex-direction: column;
    gap: 45px;
    align-items: flex-end;
    margin-left: auto;
    margin-right: 0;
    max-width: 590px;
  }

  #participacao .wpcf7 label {
    display: block;
  }

  #participacao .wpcf7 input {
    font-size: 18px;
    /* padding: 10px 15px; */
    padding: 16px;
    border: 1px solid #000;
    display: block;
    width: 100%;
    max-width: 100%;
  }

  #participacao .wpcf7 input[name="your-phone"],
  #participacao .wpcf7 input[name="your-company"] {
    max-width: 60%;
    margin-left: auto;
  }

  #participacao .wpcf7 .wpcf7-acceptance label {
    display: flex;
    gap: 17px;
    text-align: left;
  }

  #participacao .wpcf7 .wpcf7-acceptance input {
    padding: 13px;
    border-radius: 0;
    width: auto;
    transition: .2s;
  }

  #participacao .wpcf7 .form-check-input:checked[type="checkbox"] {
    background-color: #ad132a;
  }

  #participacao .wpcf7 input[type="submit"] {
    background: #ad132a;
    color: #fff;
    border: none;
    border-radius: 999px;
    padding: 10px 30px;
    font-size: 18px;
    margin: 0px 0 14px auto;
    width: auto;
  }

  #participacao .wpcf7 .mini-input {
    margin-left: 12vw;
    max-width: 60%;
  }

  #realizacao {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 40px
  }

  #realizacao .logos {
    width: 100%;
    display: flex;
    justify-content: space-evenly;
  }

  #realizacao .logos div {
    display: flex;
    flex-direction: column;
    gap: 20px;
    align-items: center;
    justify-content: center;
  }

  #realizacao .d-flex {
    gap: 30px 40px;
  }

  #realizacao .parceiros {
    display: flex;
    justify-content: space-evenly;
    gap: 30px;
    flex-wrap: wrap;
  }

  #realizacao .parceiros img {
    height: 30px;
    width: auto;
    /* max-width: 117px; */
  }

  .mandala {
    position: absolute;
    top: -8vw;
    right: -18.3vw;

  }

  #btn-validate {
    background: #ad132a;
    color: #fff;
    border: none;
    border-radius: 999px;
    padding: 10px 60px;
    font-size: 18px;
    margin: 0px 0 14px auto;
    width: auto;
  }

  .petala {
    position: absolute;
    left: -28vw;
    width: 44vw;
    top: 34vw;
  }

  .petala.cta {
    position: absolute;
    left: -28vw;
    width: 35vw;
    top: 29vw;
  }

  .footer {
    display: flex;
    align-items: center;
    gap: 10vw;
    display: flex;
    align-items: center;
    margin: 0 auto;
    justify-content: center;
  }

  .footer span {
    color: #ad132a;
  }

  .footer .social {
    gap: 20px;
  }

  .footer .social a {
    color: gray;
    text-decoration: none;
  }

  .footer .social a:hover i {
    color: #ad132a;
  }

  .footer div svg {
    height: 17px;
    width: auto
  }

  .footer div svg:hover {
    fill: #ad132a;
  }

  .footer ul {
    display: flex;
    flex-direction: row;
    gap: 14px
  }

  .btn-resposta {
    display: flex;
    flex-direction: row;
    align-items: center;
    gap: 16px
  }

  .input-resposta {
    display: flex;
    flex-direction: row;
  }

  .input-resposta input {
    width: 16px;
    height: 16px;
    padding: 6px
  }


  @media (max-width: 767px) {
    .body * {
      --title-size: 22px;
      padding: 0;

    }

    .body {
      width: 100%;
    }

    .body hr {
      margin: 40px auto 45px auto;
    }

    #page {
      margin: 6vw
    }

    .petala {
      display: none;
    }

    .mandala {
      width: 60vw;
      left: 20.1vw;
    }

    .modal {
      left: 5vw;
      height: 96vh;
      overflow-y: scroll;
      width: calc(100% - 40px);
    }

    #main {
      background-size: 47vw;
    }

    #hero {
      min-height: 0;
      padding-top: 180px;
    }

    #hero h1 {
      font-size: 35px;
    }

    #cta {
      background-size: 176px;
      min-height: 276px;
      background-image: none;
    }

    #fotos {
      background-image: none;
    }

    #painelistas .container-painelistas .item {
      width: 44%;
    }

    #painelistas .container-painelistas {
      gap: 37px 5%;
    }

    #programacao table {
      font-size: 16px;
    }

    #programacao tr>td:first-child {
      min-width: 88px;
    }

    #programacao::before {
      background: none;
      top: -141px;
    }

    #fotos h2::before {
      top: initial;
      left: initial;
      font-size: 22px;
      position: relative;
      display: block;
    }

    #participacao {
      padding: 0;
      background: none;
    }

    .parceiros {
      display: flex;
      align-items: center;
      justify-content: center;
      flex-wrap: wrap;
      gap: 16px
    }

    #realizacao .parceiros span {
      text-align: center;
    }

    #participacao .wpcf7,
    #participacao form {
      max-width: calc(100vw - 40px);
    }

    #participacao .wpcf7 input {
      max-width: 90%;
    }

    .mini-input {
      margin-left: 0 !important;
      max-width: 90% !important;
    }

    .btn-resposta {
      flex-direction: column
    }

    .painelistas-modal {
      height: 200px !important;
      width: auto;
      left: -19px;
      top: -44vw;
    }

    .modal-body {
      padding: 130px 30px 40px 30px !important;
    }

    .modal-txt {
      padding-top: 40px
    }

    .mobile-hide: {
      display: none !important;
    }

    #bg-flower img {
      display: none
    }

    #realizacao .logos {
      flex-direction: column;
      gap: 25px
    }

    .footer {
      flex-wrap: wrap;
      gap: 40px
    }
  }
</style>

<div class="body">
  <div style="position: relative">
    <img class="mandala" src='https://upload.madnezz.com.br/be931142cdbf8fc2923ef3ecfc51fea6' />
    <img class="petala cta" src='https://upload.madnezz.com.br/42e243c13c14d7fc02b0352a866e3456' />
  </div>
  <div id="page" class="site">
    <div id="content" class="site-content">
      <div id="primary" class="content-area">
        <main id="main" class="site-main" role="main">
          <section id="hero" class="container d-flex align-items-center">
            <h1>
              1º FÓRUM <sub>DE</sub><br />
              <strong class="d-block fw-semibold">DESENVOLVIMENTO</strong><br />
              <span>DO VAREJO</span>
              <span class="small-1 d-block"> DE BETIM <span class="small-2">E REGIÃO</span></span><br />
              <hr style="margin: 16px 0 16px 0; width:56vw; max-width: none">
              <!--	<span class="small-1" style="font-weight: 200"><img style="width:24px; height:auto; margin-right: 10px; margin-bottom: 10px" src="https://www.partagecampinagrande.com.br/wp-content/uploads/sites/4/2024/06/point.png" alt="icone mapa" /><b style="font-weight: 800">O Casarão</b> Eventos</span> -->
              <span class="small-1 d-block" style="font-weight:400; margin-top: 1%">23/05 - 19h</span>
              <br />
              <span class="small-1 d-block" style="font-weight:400; margin-top: 2%">
                <img src="https://upload.madnezz.com.br/68a116f98ec3e2fe3a77227b47d6c126" style="height: 40px" />
                Clube Atlético Rodoviário
              </span>
            </h1>
          </section>

          <hr style="margin: 100px auto 60px auto;">

          <section id="cta">
            <div class="container container col-sm-6 py-5 py-5">
              <h2>
                Queremos saber a sua opinião sobre o evento.
              </h2>
              <a class="d-block rounded-pill text-center mt-5 p-2 fs-5 fw-semibold mx-auto text-light"
                href="https://form.typeform.com/to/CDyotvOH" target="_blank">
                Clique Aqui
              </a>
            </div>
          </section>

          <hr style="margin:30px auto 95px auto">

          <section id="painelistas">
            <div class="container py-4">
              <h2 class="mb-md-6" style="margin-bottom: 4vw"><b>Painelistas</b> Confirmados</h2>
              <div class="container-painelistas d-flex flex-wrap text-center justify-content-center"
                style="margin-left: 1%;">

                <!-- INICIO ADRIANO CAPOBIANCO -->
                <div class="item" data-bs-toggle="modal" data-bs-target="#md-1">
                  <img class="rounded" src="img/forum/campinagrande/cards_adriano.png" alt="Foto ADRIANO CAPOBIANCO">

                  <h3>ADRIANO CAPOBIANCO</h3>
                  <h4>Diretor Comercial e de Novos Negócios Partage Malls</h4>
                  <div class="d-none pn-content">
                    Adriano Capobianco, 51 anos. Advogado, com especialização em gestão.
                    <br>
                    Superintende de shopping por 3 anos. Coordenador e diretor regional de gestão nas empresas AD
                    Shopping e Tenco Shopping Centers até 2015.
                    <br>
                    Na Partage desde janeiro de 2016.
                  </div>
                </div>
                <!-- FIM ADRIANO CAPOBIANCO -->

                <!-- INICIO CASSIO NORONHA -->
                <div class="item" data-bs-toggle="modal" data-bs-target="#md-1">
                  <img class="rounded" src="https://upload.madnezz.com.br/e21ea2c327807c42c90ad9010e232af6"
                    alt="Foto CASSIO NORONHA">
                  <h3>CASSIO NORONHA</h3>
                  <h4>CEO - Constance</h4>
                  <div class="d-none pn-content">
                    Cassio Pirfo de Noronha, fundador e CEO da Constance, a principal rede de self shoes do Brasil,
                    começou sua carreira em 1983 como sócio da Prima Línea Fábrica de Móveis.
                    <br>
                    Fundou a Constance em 2004, concentrando-se na administração da empresa. Hoje, após mais de 20 anos
                    no mercado, a Constance possui 280 lojas em todo o país, oferecendo uma experiência única para os
                    amantes de calçados.
                    <br>
                    O conceito inovador de self shoes permite aos clientes escolher e experimentar os sapatos com
                    conforto. Com o "Closet dos Sonhos", oferecem cerca de 400 modelos de bolsas, calçados e acessórios
                    para atender a todos os estilos.
                    <br>
                    O sucesso da marca, segundo Cassio, vem do compromisso em superar as expectativas dos clientes com
                    produtos duráveis e um atendimento excepcional.
                  </div>
                </div>
                <!-- FIM CASSIO NORONHA -->

                <!-- INICIO HERON GUIMARAES -->
                <div class="item" data-bs-toggle="modal" data-bs-target="#md-1">
                  <img class="rounded" src="https://upload.madnezz.com.br/9a35e6b6c5ad81d17783e0610320207a"
                    alt="Foto HERON GUIMARÃES">
                  <h3>HERON GUIMARÃES</h3>
                  <h4>Consultor Executivo - Grupo SADA</h4>
                  <div class="d-none pn-content">
                    Heron Domingues Guimarães, profissional com formação em jornalismo, publicidade e propaganda,
                    agropecuária, além de MBA em marketing e especialização em marketing político. Ex-Diretor Executivo
                    da Sempre Editora, com ampla experiência em jornalismo e gestão de mídia. Participativo em conselhos
                    como ANJ, Amirt e diretoria da Associação Sada Volei. No serviço público, atuou como assessor
                    especial e primeiro secretário de Comunicação da Prefeitura de Betim, contribuindo para a criação de
                    políticas locais. Nomeado Secretário de Gabinete e posteriormente Secretário de Saúde na gestão
                    municipal de Betim, destacou-se pela valorização das Guardas Municipais e pela resposta à epidemia
                    de dengue com inovações e melhorias nos serviços de saúde.
                  </div>
                </div>
                <!-- FIM HERON GUIMARAES -->

                <!-- INICIO MAURÍCIO MENESES -->
                <div class="item" data-bs-toggle="modal" data-bs-target="#md-1">
                  <img class="rounded" src="https://upload.madnezz.com.br/67121bdc8fd162f696ec9220052007ae"
                    alt="Foto MAURÍCIO MENESES">
                  <h3>MAURÍCIO MENESES</h3>
                  <h4>CEO - Planet Park</h4>
                  <div class="d-none pn-content">
                    Mauricio Melo Meneses, natural de MG e cidadão honorário das cidades de São Paulo, Cuiabá e do
                    Estado de MT;
                    <br>
                    1- Proprietário da Empresa de Entretenimento Familiar: “Planet Park”, presente em 18 Shopping em 7
                    Estados deste 05/05/1995;
                    <br>
                    2- Foi Superintendente de Shopping por 8 anos;
                    <br>
                    3- Foi Presidente por 4 anos do Instituto Presbiteriano Mackenzie, mantenedor da Universidade,
                    Colégios e Hospitais Mackenzie;
                    <br>
                    4- É membro dos Conselhos de Administração do Mackenzie desde 2006, da Universidade Evangélica de
                    Goiás desde 2018, do Instituto Liberal desde 2021 e Presidente do Centro Mackenzie de Liberdade
                    Econômica, além de Presidente da Academia Brasileira de Filatelia;
                    <br>
                    5-Engenheiro e Economista, e Pós-graduado em Educação, Heveicultura e em Liderança Avançada.
                  </div>
                </div>
                <!-- FIM MAURÍCIO MENESES -->
                <br>
                <!-- INICIO NAVARRO CANDIDO -->
                <div class="item" data-bs-toggle="modal" data-bs-target="#md-1">
                  <img class="rounded" src="https://upload.madnezz.com.br/a7b4a14501bd2034a7f598c887858c62"
                    alt="Foto MAURÍCIO MENESES">
                  <h3>NAVARRO CÂNDIDO</h3>
                  <h4>Diretor e Sócio-Fundador - SuperLuna</h4>
                  <div class="d-none pn-content">
                    Navarro Agostinho Cândido é sócio fundador do supermercado SuperLuna desde 1989. Além disso, em
                    2008, foi um dos sócios fundadores da LNX Empreendimentos e, posteriormente, em 2015, fundou a NAC.
                    Ele também desempenha o papel de vice-presidente da Associação Mineira de Supermercados (AMIS) e
                    atua como conselheiro da ORCCA.
                  </div>
                </div>
                <!-- FIM NAVARRO CANDIDO -->

                <!-- INICIO OSVALDO OLIVEIRA -->
                <div class="item" data-bs-toggle="modal" data-bs-target="#md-1">
                  <img class="rounded" src="https://upload.madnezz.com.br/aad016b20dd09862cf3b4760e6698a7b"
                    alt="Foto OSVALDO OLIVEIRA">
                  <h3>OSVALDO OLIVEIRA</h3>
                  <h4>Coord. do Curso de Administração - PUC Minas</h4>
                  <small></small>
                  <div class="d-none pn-content">
                    Nascido em Betim, em uma familia de empreendedores. É Mestre
                    em Administração; Especialista em Gestão Estratégica Financeira Corporativa pela UFMG, Graduação em
                    Administração pela Pontifícia Universidade Católica de Minas Gerais.
                    <br>
                    Atualmente é coordenador do curso de Administração da PUC Minas em Betim; Coordenador do HUB de
                    Inovação em Negócios IDEIAS Lab e do HUB de Extensão Proex - PUC Minas. Professor à mais de 20 anos
                    na PUC Minas em cursos de graduação e Pós-graduação.
                    <br>
                    É Consultor em Gestão Estratégica e Financeira de Negócios pela empresa ORITUS Consultoria. Tem
                    experiência na área de Administração, com ênfase em Finanças e Sustentabilidade Corporativa - ESG.  

                  </div>
                </div>
                <!-- FIM OSVALDO OLIVEIRA -->
                <!-- INICIO SHIRLEI MIRANDA -->
                <div class="item" data-bs-toggle="modal" data-bs-target="#md-1">
                  <img class="rounded" src="https://upload.madnezz.com.br/868f79ea7a1ad71b1a00ea6f82577df2"
                    alt="Foto SHIRLEI MIRANDA">
                  <h3>SHIRLEI MIRANDA</h3>
                  <h4>Presidente - CDL Mulher</h4>
                  <div class="d-none pn-content">
                    Comerciante há mais de 15 anos, é proprietária da Noni, loja de roupas e acessórios femininos,
                    localizada no bairro Angola, em frente a PUC Minas.
                    <br>
                    Há 25 anos eleva a autoestima de mulheres através da moda.
                    <br>
                    Atualmente, é Coordenadora-geral da CDL Betim Mulher Empreendedora e inspira as associadas a
                    prosperarem nos negócios.
                  </div>
                </div>
                <!-- Fim SHIRLEI MIRANDA -->
                <!-- INICIO THIAGO ROLDÃO -->
                <div class="item" data-bs-toggle="modal" data-bs-target="#md-1">
                  <img class="rounded" src="https://upload.madnezz.com.br/d4a05dfa5f419cebc8fe71344fbd17c2"
                    style="width:100%" alt="Foto MARCOS BOTEGA">
                  <h3>MARCOS BOTEGA</h3>
                  <h4>Diretor de Expansão - Grupo Localiza&CO</h4>
                  <div class="d-none pn-content">
                    <br class="mobile-hide">
                    <br class="mobile-hide">
                    <br class="mobile-hide">
                  </div>
                </div>
                <!-- Fim THIAGO ROLDÃO -->
              </div>
            </div>
          </section>
          <section id="programacao" class="position-relative">
            <div class="container pb-md-5">
              <hr>
              <h2 class="mb-md-6" style="margin-bottom: 4vw">Programação</h2>
              <table class="col-md-9 m-auto">
                <tbody>
                  <tr>
                    <td>19h00 -</td>
                    <td><b style="font-weight: 600">Abertura</b></td>
                  </tr>
                  <tr>
                    <td>20h00 -</td>
                    <td style="padding-top: 22px">“<b style="font-weight: 600">Betim e Região</b> - Desenvolvimento e
                      Negócios, no coração <br>
                      de Minas Gerais”. <span>(Painel 1)</span></td>
                  </tr>
                  <tr>
                    <td>20h45 -</td>
                    <td>“<b style="font-weight: 600">O Varejo Mineiro</b>: Tradição, Inovação e Visão de Futuro”.
                      <span>(Painel 2)</span>
                    </td>
                  </tr>
                  <tr>
                    <td>21h30 -</td>
                    <td><b style="font-weight: 600">Coquetel e Atração</b></td>
                  </tr>
                </tbody>
              </table>
            </div>
          </section>

          <hr style="margin:95px auto 95px auto">
          <section id="realizacao" class="container px-4 pb-md-6">
            <div class="logos">
              <div class="">
                <span>REALIZAÇÃO:</span>
                <img src="https://upload.madnezz.com.br/7557e53d46bdc75b278ddd74ceb58d9c" alt="Logo Partage Marabá"
                  style="max-width: 220px;">
              </div>
              <div class="">
                <span>APOIO:</span>
                <img src="https://upload.madnezz.com.br/5563e0bd5d86635a9144d2d9572b8eb9" alt="Logo Partage Malls"
                  style="max-width: 148px;">
              </div>
            </div>
            <div>
              <span class="w-100 text-center">Parceiros:</span>
            </div>
            <div class="parceiros">
              <img src="https://upload.madnezz.com.br/1cfaa9a9bd1686d2284cd55f0b79cf72" alt="Logo Aramins">
              <img src="https://upload.madnezz.com.br/3b39ea8a4483e80cab01b4456b6a3746" alt="Logo Constance">
              <img src="https://upload.madnezz.com.br/09433ad557c7d9400ae525ea67b9a542" alt="Logo Havanna">
              <img src="https://upload.madnezz.com.br/102063958c4006b74f042a6372aae93e" alt="Logo L'occitane">
              <img src="https://upload.madnezz.com.br/eb590c763643008876dceaa4d46d4a86" alt="Logo Loungerie">
              <img src="https://upload.madnezz.com.br/f1b212b2f2dee713a9657015ae2d4017" alt="Logo Puket">
            </div>
          </section>
        </main><!-- #main -->
        <hr style="margin:95px auto 95px auto">
        <div class="footer container">
          <div class="col-md-3 text-center">
            <img src="https://upload.madnezz.com.br/5563e0bd5d86635a9144d2d9572b8eb9" alt="Logo Partage Malls"
              style="max-width: 140px;">
          </div>
          <div class="col-md-6 my-4 my-mb-0">
            <span class="d-block fs-6 text-center">© 2024 Partage - Todos os direitos reservados</span>
          </div>
          <div class="d-flex justify-content-center justify-content-md-end col-md-3 fs-5 social">
            <ul>
              <li>
                <a href="https://www.facebook.com/partagemalls/" target="_blank" rel="nofolow" title="Facebook">
                  <svg class="e-font-icon-svg e-fab-facebook-f" viewBox="0 0 320 512" xmlns="http://www.w3.org/2000/svg"
                    style="fill: gray; margin-top: -4px;">
                    <path
                      d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z">
                    </path>
                  </svg>
                </a>
              </li>
              <li>
                <a href="https://www.instagram.com/partagemalls/" target="_blank" rel="nofolow" title="Instagram">
                  <svg class="e-font-icon-svg e-fab-instagram" viewBox="0 0 448 512" xmlns="http://www.w3.org/2000/svg"
                    style="fill: gray; margin-top: -4px;">
                    <path
                      d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z">
                    </path>
                  </svg>
                </a>
              </li>
              <li>
                <a href="https://www.linkedin.com/company/5239857/admin/feed/posts/" target="_blank" rel="nofolow"
                  title="LinkedIn">
                  <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-linkedin" viewBox="0 0 16 16"
                    style="fill: gray; margin-top: -4px;">
                    <path
                      d="M0 1.146C0 .513.526 0 1.175 0h13.65C15.474 0 16 .513 16 1.146v13.708c0 .633-.526 1.146-1.175 1.146H1.175C.526 16 0 15.487 0 14.854zm4.943 12.248V6.169H2.542v7.225zm-1.2-8.212c.837 0 1.358-.554 1.358-1.248-.015-.709-.52-1.248-1.342-1.248S2.4 3.226 2.4 3.934c0 .694.521 1.248 1.327 1.248zm4.908 8.212V9.359c0-.216.016-.432.08-.586.173-.431.568-.878 1.232-.878.869 0 1.216.662 1.216 1.634v3.865h2.401V9.25c0-2.22-1.184-3.252-2.764-3.252-1.274 0-1.845.7-2.165 1.193v.025h-.016l.016-.025V6.169h-2.4c.03.678 0 7.225 0 7.225z" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="https://www.youtube.com/channel/UC8P6r-04tabsTyHdXZFhx7g" target="_blank" rel="nofolow"
                  title="YouTube">
                  <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16"
                    style="fill: gray; margin-top: -4px;">
                    <path
                      d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="https://twitter.com/ShoppingPartage" target="_blank" rel="nofolow" title="X">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" style="fill: gray; margin-top: -4px;">
                    <path
                      d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z" />
                  </svg>
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div><!-- #primary -->
    </div><!-- #content -->
  </div><!-- #page -->

  <!-- Modal -->
  <div class="modal fade" id="md-1" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <a href="#" class="btn-close" aria-label="Close">&times;</a>
        </div>

        <div
          style="border-top:1px solid #A21D16; border-left: 1px solid #A21D16; border-radius: 30px 130px ; padding: 10px 0 0 10px;">
          <div class="modal-body">
            <div class="container-fluid">
              <div class="row">
                <div class="col-md-4" style="position:relative">
                  <img id="modal-img" class="rounded painelistas-modal">
                </div>
                <div class="modal-txt  col-md-8">
                  <h3 id="modal-name" class="my-1" style="color:#A21D16; font-weight:600"></h3>
                  <h4 id="modal-position" class="fs-6 mb-2"></h4>
                  <p id="modal-text"></p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script type="text/javascript">
    // Seleciona todos os elementos que devem abrir o modal
    const items = document.querySelectorAll('.item');

    items.forEach(item => {
      item.addEventListener('click', function () {
        const modal = document.getElementById('md-1');
        const tgt = item;

        // Atualiza o conteúdo do modal com os dados do item clicado
        modal.querySelector('#modal-img').src = tgt.querySelector('img').src;
        modal.querySelector('#modal-name').textContent = tgt.querySelector('h3').textContent;
        modal.querySelector('#modal-position').textContent = tgt.querySelector('h4').textContent;
        modal.querySelector('#modal-text').textContent = tgt.querySelector('.pn-content').textContent;

        // Exibe o modal
        modal.classList.add('show');
        modal.style.display = 'block';
      });
    });

    // Função para fechar o modal
    document.querySelector('.btn-close').addEventListener('click', function (e) {
      e.preventDefault(); // Evita o comportamento padrão do link
      const modal = document.getElementById('md-1');
      modal.classList.remove('show');
      modal.style.display = 'none';
      modal.setAttribute('aria-hidden', 'true');
      modal.setAttribute('tabindex', '-1');

      // Mover o foco de volta para o elemento que abriu o modal
      document.querySelector('[data-bs-target="#md-1"]').focus();
    });

    // Fechar o modal ao clicar fora do conteúdo
    modal.addEventListener('click', function (event) {
      if (event.target === modal) {
        modal.classList.remove('show');
        modal.style.display = 'none';
      }
    });

  </script>

</div>


<?php include 'assets/inc/footer.php'; ?>